/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpManager.IPAddress;
import ibm.nways.analysis.dpManager.SortableObject;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DPERange
implements Serializable,
SortableObject {
    private InetAddress dpe;
    private String stringDPE;
    private long startRange;
    private long endRange;
    private String startRangeString;
    private String endRangeString;

    public DPERange(String string, String string2, String string3) {
        try {
            this.stringDPE = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        this.startRange = IPAddress.toLong(string2);
        this.endRange = IPAddress.toLong(string3);
        this.startRangeString = IPAddress.toString(this.startRange);
        this.endRangeString = IPAddress.toString(this.endRange);
    }

    public DPERange(String string, long l, long l2) {
        try {
            this.stringDPE = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        this.startRangeString = IPAddress.toString(l);
        this.endRangeString = IPAddress.toString(l2);
        this.startRange = l;
        this.endRange = l2;
    }

    public long sortKey() {
        return this.startRange;
    }

    public String getDPEAddress() {
        return this.stringDPE;
    }

    public void setDPEAddress(String string) {
        this.stringDPE = string;
    }

    public String getStartRangeString() {
        return this.startRangeString;
    }

    public String getEndRangeString() {
        return this.endRangeString;
    }

    public long getStartRange() {
        return this.startRange;
    }

    public long getEndRange() {
        return this.endRange;
    }

    public void setStartIp(long l) {
        this.startRange = l;
        this.startRangeString = IPAddress.toString(this.startRange);
    }

    public void setEndIp(long l) {
        this.endRange = l;
        this.endRangeString = IPAddress.toString(this.endRange);
    }

    public long getStartIp() {
        return this.startRange;
    }

    public long getEndIp() {
        return this.endRange;
    }

    public InetAddress inRange(String string) {
        long l = IPAddress.toLong(string);
        if (l >= this.startRange && l <= this.endRange) {
            return this.dpe;
        }
        return null;
    }

    public boolean inRange(DPERange dPERange) {
        return dPERange.getDPEAddress().equals(this.getDPEAddress()) && dPERange.getStartRange() >= this.getStartRange() && dPERange.getEndRange() <= this.getEndRange();
    }

    public boolean greater(Object object) {
        return false;
    }

    public boolean equals(DPERange dPERange) {
        return this.stringDPE.equals(dPERange.getDPEAddress()) && this.startRange == dPERange.getStartIp() && this.endRange == dPERange.getEndIp();
    }

    public String toListString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startRangeString);
        stringBuffer.append(" - ");
        stringBuffer.append(this.endRangeString);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startRangeString);
        stringBuffer.append(" - ");
        stringBuffer.append(this.endRangeString);
        stringBuffer.append(" DPE: ");
        stringBuffer.append(this.stringDPE);
        stringBuffer.append(" SortKey: ");
        stringBuffer.append(this.sortKey());
        return stringBuffer.toString();
    }
}

